using System;
using System.Collections;
using System.Reflection;
using System.Drawing;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Skin : Item
	{
		#region Properties
		private int m_nDBSkinID = -1;
		#endregion


		public Skin()
		{
			this.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
		}
		public Skin( ComplexEntity oParentEntity )
		{
			this.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
			this.ParentEntity = oParentEntity;
		}


		public override DSSerialize Serialize(Session oSession)
		{
			DSSerialize oSerialize = new DSSerialize();


			//Now save our data
            oSerialize.Set(0, base.Serialize(oSession));
			oSerialize.Set( 1,m_nDBSkinID );


			return( oSerialize );
		}
        public override void DeSerialize(Session oSession, DSSerialize oSerialize)
		{
			base.DeSerialize( oSession,(DSSerialize)oSerialize.Get( 0 ) );
			m_nDBSkinID = oSerialize.GetInt( 1 );
		}



		#region Properties
		public int DBSkinID
		{
			get
			{
				return( m_nDBSkinID );
			}
			set
			{
				m_nDBSkinID = value;
			}
		}
		#endregion
	}
}
